import { Metadata } from 'next';
import { Suspense } from 'react';
import AnalyzerClient from '@/components/analyzer/AnalyzerClient';

export const metadata: Metadata = {
    title: 'Domain & Network Analyzer - Super Tool',
    description: 'Comprehensive domain analysis tool including WHOIS, DNS, Blacklist check, SSL verification, and IP information.',
};

export default function AnalyzePage() {
    return (
        <Suspense fallback={<div className="min-h-screen flex items-center justify-center">Loading...</div>}>
            <AnalyzerClient />
        </Suspense>
    );
}
