import BlacklistClient from "@/components/blacklist-checker/BlacklistClient";
import { Metadata } from "next";

export const metadata: Metadata = {
    title: "Blacklist Checker & IP Reputation Monitor",
    description: "Check if your IP or domain is blacklisted on 50+ DNSBL databases. Improve email deliverability by identifying and removing blacklist blocks.",
    keywords: ["blacklist check", "ip reputation", "rbl monitor", "spamhaus check", "dnsbl lookup", "email blacklist", "spam list"],
};

export default function BlacklistPage() {
    return <BlacklistClient />;
}
