import HttpHeadersClient from "@/components/http-headers/HttpHeadersClient";
import { Metadata } from "next";

export const metadata: Metadata = {
    title: "HTTP Header Analyzer & Scanner",
    description: "Inspect HTTP response headers for security and performance. Check Content-Security-Policy, HSTS, Server tokens, and Cache-Control headers.",
    keywords: ["http headers", "security headers", "csp check", "hsts checker", "server headers", "http status", "header analyzer"],
};

export default function HttpHeadersPage() {
    return <HttpHeadersClient />;
}
