import { Hero } from "@/components/home/Hero";
import { ToolGrid } from "@/components/home/ToolGrid";
import { LivePulse } from "@/components/home/LivePulse";
import { Features } from "@/components/home/Features";
import { Newsletter } from "@/components/home/Newsletter";

import { Metadata } from "next";

export const metadata: Metadata = {
  title: "DNS Tool - Professional Network & SEO Utilities",
  description: "All-in-one suite for DNS lookup, email health (SPF, DKIM, DMARC), network diagnostics (Ping, Trace), and SEO inspection.",
  keywords: ["dns tools", "network tools", "seo tools", "webmaster tools", "ip lookup", "email deliveries", "dnssec checker"],
};

export default function Home() {
  return (
    <div className="min-h-screen bg-white font-sans selection:bg-[#2563EB] selection:text-white">
      <main className="flex flex-col w-full">
        <Hero />
        <LivePulse />
        <ToolGrid />
        <Features />
        <Newsletter />
      </main>
    </div>
  );
}
