"use client";

import React from "react";
import { Globe, Shield, Activity, Search, ShieldCheck, Mail, Server, Zap, Wifi } from "lucide-react";

// Mock Data with more variety
const liveEvents = [
    { text: "DNS Propagation Check: google.com", location: "Global", icon: Globe, color: "text-blue-500", bg: "bg-blue-500/10", border: "border-blue-200" },
    { text: "Port Scan Detected: 192.168.x.x", location: "US", icon: Activity, color: "text-red-500", bg: "bg-red-500/10", border: "border-red-200" },
    { text: "SSL Certificate Validated: stripe.com", location: "US", icon: ShieldCheck, color: "text-green-500", bg: "bg-green-500/10", border: "border-green-200" },
    { text: "MX Record Audit: microsoft.com", location: "EU", icon: Mail, color: "text-purple-500", bg: "bg-purple-500/10", border: "border-purple-200" },
    { text: "Blacklist Monitor: Clean IP found", location: "UK", icon: Shield, color: "text-emerald-500", bg: "bg-emerald-500/10", border: "border-emerald-200" },
    { text: "WHOIS Lookup: vercel.com", location: "US", icon: Search, color: "text-amber-500", bg: "bg-amber-500/10", border: "border-amber-200" },
    { text: "Latency Test: Cloudflare DNS", location: "SG", icon: Zap, color: "text-cyan-500", bg: "bg-cyan-500/10", border: "border-cyan-200" },
    { text: "Traceroute: amazon.com", location: "JP", icon: Wifi, color: "text-indigo-500", bg: "bg-indigo-500/10", border: "border-indigo-200" },
    { text: "Server Status: 99.9% Uptime", location: "DE", icon: Server, color: "text-slate-500", bg: "bg-slate-500/10", border: "border-slate-200" },
];

export const LivePulse = () => {
    return (
        <div className="w-full h-14 bg-white border-y border-slate-100 flex items-center overflow-hidden shadow-[0_4px_20px_-10px_rgba(0,0,0,0.05)] relative z-20">
            {/* Label */}
            <div className="flex items-center gap-3 px-6 h-full bg-white border-r border-slate-100 shrink-0 z-10 relative shadow-[4px_0_24px_-4px_rgba(0,0,0,0.05)]">
                <div className="relative flex items-center justify-center w-3 h-3">
                    <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-red-400 opacity-75"></span>
                    <span className="relative inline-flex rounded-full h-2.5 w-2.5 bg-red-500"></span>
                </div>
                <span className="text-xs font-bold text-slate-900 tracking-widest uppercase font-jakarta">
                    System Feed
                </span>
            </div>

            {/* Marquee Container */}
            <div className="flex-1 overflow-hidden relative flex items-center group/marquee">
                {/* Gradient Masks */}
                <div className="absolute left-0 top-0 bottom-0 w-16 bg-gradient-to-r from-white to-transparent z-10 pointer-events-none" />
                <div className="absolute right-0 top-0 bottom-0 w-16 bg-gradient-to-l from-white to-transparent z-10 pointer-events-none" />

                {/* CSS Animation Wrapper */}
                <div
                    className="flex items-center gap-4 whitespace-nowrap animate-scroll group-hover/marquee:paused"
                    style={{
                        animation: 'scroll 60s linear infinite',
                    }}
                >
                    {/* Triple duplication for seamless loop */}
                    {[...liveEvents, ...liveEvents, ...liveEvents, ...liveEvents].map((item, i) => (
                        <div
                            key={i}
                            className="flex items-center gap-3 px-4 py-1.5 rounded-full border border-transparent hover:border-slate-200 hover:bg-slate-50 hover:shadow-sm transition-all duration-200 cursor-default group/item transform hover:scale-105"
                        >
                            <div className={`p-1.5 rounded-full ${item.bg} ${item.color} group-hover/item:ring-2 ring-opacity-20 ring-current transition-all`}>
                                <item.icon className="w-3.5 h-3.5" />
                            </div>
                            <div className="flex items-center gap-2">
                                <span className="text-xs font-medium text-slate-600 font-jakarta group-hover/item:text-slate-900 transition-colors">
                                    {item.text}
                                </span>
                                <span className={`text-[9px] font-bold px-1.5 py-0.5 rounded border ${item.border} ${item.bg} ${item.color.replace('text-', 'text-opacity-80 text-')}`}>
                                    {item.location}
                                </span>
                            </div>
                        </div>
                    ))}
                </div>
            </div>

            <style jsx>{`
                @keyframes scroll {
                    0% { transform: translateX(0); }
                    100% { transform: translateX(-50%); }
                }
                .animate-scroll {
                    /* Width must be large enough to contain duplicated items */
                    min-width: max-content;
                }
                .paused {
                    animation-play-state: paused;
                }
            `}</style>
        </div>
    );
};
