"use client";

import React from "react";
import { Mail, ArrowRight } from "lucide-react";
import { LiveGlobe } from "./LiveGlobe";

export const Newsletter = () => {
    return (
        <section className="py-24 bg-white border-t border-slate-100 overflow-hidden relative">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="flex flex-col lg:flex-row items-center justify-between gap-16">

                    {/* Left: Content */}
                    <div className="flex-1 max-w-xl text-center lg:text-left z-10">
                        <div className="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-sm font-bold uppercase tracking-wider mb-6 border border-blue-100">
                            <Mail className="w-4 h-4" />
                            Stay Updated
                        </div>
                        <h2 className="text-4xl md:text-5xl font-black text-slate-900 font-jakarta mb-6 leading-tight">
                            Join the <span className="text-blue-600">Global</span> Network.
                        </h2>
                        <p className="text-slate-500 text-lg mb-8 leading-relaxed">
                            Get notified about new diagnostic tools, API features, and network security trends. Join 10,000+ developers.
                        </p>

                        <form className="flex flex-col sm:flex-row gap-3">
                            <input
                                type="email"
                                placeholder="developer@example.com"
                                className="flex-1 px-6 py-4 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 outline-none focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all font-medium"
                            />
                            <button className="px-8 py-4 bg-blue-600 hover:bg-blue-700 text-white font-bold rounded-2xl transition-all shadow-lg shadow-blue-500/30 flex items-center justify-center gap-2">
                                Subscribe <ArrowRight className="w-5 h-5" />
                            </button>
                        </form>
                        <div className="mt-4 flex items-center gap-4 justify-center lg:justify-start">
                            <div className="flex -space-x-2">
                                <div className="w-8 h-8 rounded-full bg-slate-200 border-2 border-white" />
                                <div className="w-8 h-8 rounded-full bg-slate-300 border-2 border-white" />
                                <div className="w-8 h-8 rounded-full bg-slate-400 border-2 border-white" />
                            </div>
                            <span className="text-sm font-bold text-slate-500">Joined by 10k+ devs</span>
                        </div>
                    </div>

                    {/* Right: Globe */}
                    <div className="flex-1 w-full flex items-center justify-center relative">
                        {/* Glow Effect */}
                        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[500px] h-[500px] bg-blue-500/20 rounded-full blur-[100px]" />
                        <LiveGlobe />
                    </div>

                </div>
            </div>
        </section>
    );
};
